(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     38845,       1133]
NotebookOptionsPosition[     35523,       1035]
NotebookOutlinePosition[     36168,       1057]
CellTagsIndexPosition[     36125,       1054]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Cassegrain combinations", "Title",
 CellChangeTimes->{{3.43874789515625*^9, 3.438747901515625*^9}}],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["CassegrainCombination",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["ft",
           FontWeight->Bold], Cell["total focal length"]},
         {Cell["em",
           FontWeight->Bold], Cell["back distance"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["CassegrainCombinationInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cassegrain combinations", "Title",
 CellChangeTimes->{{3.677296496681916*^9, 3.677296503711926*^9}}],

Cell["\<\
This notebook gives all the possible configurations of a Cassegrain telescope.
In the first part, the theoretical bases of this configuration are discussed \
whereas, in the second part, the program and its applications are presented.
A Cassegrain combination is formed by two mirrors, with the aperture stop at \
the primary. At least one of the mirrors is conic.\
\>", "Text",
 CellChangeTimes->{
  3.394515079375*^9, {3.394515129484375*^9, 3.39451513765625*^9}, {
   3.394515174828125*^9, 3.39451519775*^9}, {3.394515230296875*^9, 
   3.394515300625*^9}, {3.39451533153125*^9, 3.39451533334375*^9}, {
   3.394515392453125*^9, 3.394515405640625*^9}, {3.39451545175*^9, 
   3.394515456578125*^9}, {3.39451564453125*^9, 3.394515667453125*^9}, 
   3.394515720578125*^9, {3.413808819828125*^9, 3.41380887425*^9}, {
   3.41380890509375*^9, 3.413808906890625*^9}, {3.4145110838125*^9, 
   3.414511085703125*^9}, {3.423716714421875*^9, 3.423716726453125*^9}, {
   3.437455254859375*^9, 3.437455307078125*^9}, 3.43745535109375*^9, {
   3.437455387421875*^9, 3.437455395515625*^9}, {3.64692220196875*^9, 
   3.646922212953125*^9}, {3.646922254453125*^9, 3.646922255125*^9}, {
   3.646922319390625*^9, 3.64692233390625*^9}, {3.666007364078125*^9, 
   3.66600738978125*^9}, 3.677295472160482*^9},
 FontSize->18],

Cell["\<\
The Gaussian design starts from the input data: f1, ft and em to determine \
the following quantity\
\>", "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"\[Alpha]", "=", 
   FractionBox["em", "f1"]}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.677295475690487*^9, 3.677295486770502*^9}, 
   3.677296953386945*^9, {3.6772970112970257`*^9, 3.677297066437103*^9}, {
   3.6772971526272235`*^9, 3.6772971545872264`*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"M", "=", 
   FractionBox["ft", "f1"]}], TraditionalForm]],
 FormatType->"TraditionalForm"]], "Text",
 CellChangeTimes->{{3.6772970741171136`*^9, 3.677297083887127*^9}, {
  3.6772971312971935`*^9, 3.6772971348771987`*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"\[Beta]", "=", 
   FractionBox[
    RowBox[{"M", "-", "\[Alpha]"}], 
    RowBox[{"M", "+", "1"}]]}], TraditionalForm]],
 FormatType->"TraditionalForm"]], "Text",
 CellChangeTimes->{{3.677297088177133*^9, 3.6772971025571537`*^9}, {
  3.677297138667204*^9, 3.677297141667208*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"\[Gamma]", "=", 
   FractionBox[
    RowBox[{"2", "M", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], 
    RowBox[{"1", "-", 
     SuperscriptBox["M", "2"]}]]}], TraditionalForm]],
 FormatType->"TraditionalForm"]], "Text",
 CellChangeTimes->{{3.677297106327159*^9, 3.677297147297216*^9}}],

Cell["\<\
\[Alpha]  and M are taken as the fundamental variables when the following \
quantities are introduced:\
\>", "Text",
 CellChangeTimes->{
  3.394515079375*^9, {3.394515129484375*^9, 3.39451513765625*^9}, {
   3.394515174828125*^9, 3.39451519775*^9}, {3.394515230296875*^9, 
   3.394515300625*^9}, {3.39451533153125*^9, 3.39451533334375*^9}, {
   3.394515392453125*^9, 3.394515405640625*^9}, {3.39451545175*^9, 
   3.394515456578125*^9}, {3.39451564453125*^9, 3.394515667453125*^9}, 
   3.394515720578125*^9, {3.413808819828125*^9, 3.41380887425*^9}, {
   3.41380890509375*^9, 3.413808906890625*^9}, {3.4145110838125*^9, 
   3.414511085703125*^9}, {3.423716714421875*^9, 3.423716726453125*^9}, {
   3.437455254859375*^9, 3.437455307078125*^9}, 3.43745535109375*^9, {
   3.437455387421875*^9, 3.437455395515625*^9}, {3.64692220196875*^9, 
   3.646922212953125*^9}, {3.646922254453125*^9, 3.646922255125*^9}, {
   3.646922319390625*^9, 3.64692233390625*^9}, {3.666007364078125*^9, 
   3.66600738978125*^9}, {3.6772971655972414`*^9, 3.677297175187255*^9}},
 FontSize->18],

Cell["\<\
R1 = \[Dash]2 f1 = primary radius;
R2 = \[Gamma] f1 = secondary radius (\[Gamma] < 0);
s12 = \[Dash] \[Beta] f1 = distance of the secondary from primary (\[Beta] > \
0);
K1 = conic constant of primary;
K2  = conic constant of secondary.\
\>", "Text",
 CellChangeTimes->{
  3.394515079375*^9, {3.394515129484375*^9, 3.39451513765625*^9}, {
   3.394515174828125*^9, 3.39451519775*^9}, {3.394515230296875*^9, 
   3.394515300625*^9}, {3.39451533153125*^9, 3.39451533334375*^9}, {
   3.394515392453125*^9, 3.394515405640625*^9}, {3.39451545175*^9, 
   3.394515456578125*^9}, {3.39451564453125*^9, 3.394515667453125*^9}, 
   3.394515720578125*^9, {3.413808819828125*^9, 3.41380887425*^9}, {
   3.41380890509375*^9, 3.413808906890625*^9}, {3.4145110838125*^9, 
   3.414511085703125*^9}, {3.423716714421875*^9, 3.423716726453125*^9}, {
   3.437455254859375*^9, 3.437455307078125*^9}, 3.43745535109375*^9, {
   3.437455387421875*^9, 3.437455395515625*^9}, {3.64692220196875*^9, 
   3.646922212953125*^9}, {3.646922254453125*^9, 3.646922255125*^9}, {
   3.646922319390625*^9, 3.64692233390625*^9}, {3.666007364078125*^9, 
   3.66600738978125*^9}, {3.6772971655972414`*^9, 3.677297202527293*^9}},
 FontSize->18],

Cell["\<\
Using these quantities as input for the function TotalAberrations, can be \
derived all the characteristics of the combination (the variables f1, \
\[Beta], \[Gamma], M, \[Alpha], r, x, \[Theta], \[Lambda], K1, K2 have to be \
unassigned, for that we use Clear)\
\>", "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "f1", ",", "\[Beta]", ",", "\[Gamma]", ",", "M", ",", "\[Alpha]", ",", "r",
     ",", "x", ",", "\[Theta]", ",", "\[Lambda]", ",", "K1", ",", "K2"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", "=", 
   FractionBox[
    RowBox[{"M", "-", "\[Alpha]"}], 
    RowBox[{"M", "+", "1"}]]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   FractionBox[
    RowBox[{"2", " ", "M", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], 
    RowBox[{"1", "-", 
     SuperscriptBox["M", "2"]}]]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"rad", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "f1"}], ",", 
     RowBox[{"\[Gamma]", " ", "f1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], " ", "f1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"K1", ",", "K2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "\[Theta]", ",", 
   RowBox[{"{", "\[Lambda]", "}"}], ",", " ", 
   RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}]}], 
  "]"}]}], "Input"],

Cell["Then, the total spherical and coma coefficients are: ", "Text",
 CellChangeTimes->{{3.4129562306875*^9, 3.412956252984375*^9}},
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"D1", "=", 
   FractionBox[
    RowBox[{
     RowBox[{"K2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "M"}], ")"}], "3"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "M"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "K1"}], ")"}], " ", 
         SuperscriptBox["M", "3"]}], "+", "\[Alpha]", "-", 
        RowBox[{
         SuperscriptBox["M", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]}], ")"}]}]}], 
    RowBox[{"32", " ", 
     SuperscriptBox["f1", "3"], " ", 
     SuperscriptBox["M", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "M"}], ")"}]}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"D2", "=", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "K2"}], ")"}], " ", 
      SuperscriptBox["M", "4"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "K2"}], ")"}], " ", "\[Alpha]"}], "+", 
     RowBox[{
      SuperscriptBox["M", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "\[Alpha]", "+", 
        RowBox[{"3", " ", "K2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{
      SuperscriptBox["M", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Alpha]", "+", 
        RowBox[{"K2", " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", "\[Alpha]"}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"M", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Alpha]", "-", 
        RowBox[{"K2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"3", " ", "\[Alpha]"}]}], ")"}]}]}], ")"}]}]}], 
    RowBox[{"8", " ", 
     SuperscriptBox["f1", "2"], " ", 
     SuperscriptBox["M", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "M"}], ")"}]}]]}], ";"}]}], "Input",
 CellChangeTimes->{3.3945157923125*^9, 3.412956518890625*^9}],

Cell["\<\
These formulae can be simplified by evaluating the coefficients of K1 and K2 \
in D1 and D2\
\>", "Text",
 CellChangeTimes->{
  3.39451422678125*^9, {3.42371682728125*^9, 3.423716830859375*^9}},
 FontSize->18],

Cell[BoxData[
 RowBox[{"D10", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{
       RowBox[{"32", 
        SuperscriptBox["f1", "3"], "D1"}], ",", "K1", ",", "0"}], "]"}], ",", 
     "K2", ",", "0"}], "]"}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"D11", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"32", 
      SuperscriptBox["f1", "3"], "D1"}], ",", "K1"}], "]"}], "//", 
   "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"D12", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"32", 
      SuperscriptBox["f1", "3"], "D1"}], ",", "K2"}], "]"}], "//", 
   "Simplify"}]}]], "Input"],

Cell[TextData[StyleBox["In conclusion, the spherical aberration coefficient \
writes",
 FontFamily->"Times New Roman"]], "Text",
 CellChangeTimes->{{3.41295667025*^9, 3.41295667025*^9}, {3.43745547*^9, 
  3.437455471515625*^9}, {3.677297259427373*^9, 3.6772972709373894`*^9}},
 FontSize->18],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"32", 
     SuperscriptBox[
      SubscriptBox["f", "1"], "2"], 
     SubscriptBox["D", "1"]}], "=", 
    RowBox[{
     SubscriptBox["D", "10"], "-", 
     SubscriptBox["K", "1"], "+", 
     RowBox[{
      SubscriptBox["D", "12"], 
      RowBox[{
       SubscriptBox["K", "2"], "."}]}]}]}], TraditionalForm]]],
 StyleBox[" ",
  FontFamily->"Times New Roman",
  FontSize->16]
}], "Text",
 CellChangeTimes->{{3.41295667025*^9, 3.41295667025*^9}, {3.43745547*^9, 
  3.437455471515625*^9}, {3.677297259427373*^9, 3.677297272877392*^9}},
 FontSize->18],

Cell[TextData[StyleBox["Proceeding in the same way for coma, we have",
 FontFamily->"Times New Roman"]], "Text",
 CellChangeTimes->{{3.41295667025*^9, 3.41295667025*^9}, {3.43745547*^9, 
  3.437455471515625*^9}, {3.677297259427373*^9, 3.6772972746273947`*^9}},
 FontSize->18],

Cell[BoxData[
 RowBox[{"D20", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{
       RowBox[{"8", 
        SuperscriptBox["f1", "2"], "D2"}], ",", "K1", ",", "0"}], "]"}], ",", 
     "K2", ",", "0"}], "]"}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"D21", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"8", 
      SuperscriptBox["f1", "2"], "D2"}], ",", "K1"}], "]"}], "//", 
   "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"D22", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"8", 
      SuperscriptBox["f1", "2"], "D2"}], ",", "K2"}], "]"}], "//", 
   "Simplify"}]}]], "Input"],

Cell[BoxData[
 StyleBox[
  RowBox[{" ", 
   RowBox[{
   "and", " ", "coma", " ", "coefficient", " ", "assumes", " ", "the", " ", 
    "following", " ", "form"}]}],
  FontFamily->"Times New Roman",
  FontSize->18]], "Text",
 CellChangeTimes->{{3.437455479234375*^9, 3.437455485078125*^9}, {
  3.677297282697406*^9, 3.677297283037406*^9}},
 FontSize->16],

Cell[BoxData[
 StyleBox[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{"8", 
      SuperscriptBox[
       SubscriptBox["f", "1"], "2"], 
      SubscriptBox["D", "2"]}], "=", 
     RowBox[{
      SubscriptBox["D", "20"], "+", 
      RowBox[{
       SubscriptBox["D", "22"], 
       SubscriptBox["K", "2"]}]}]}],
    FontSize->18],
   TraditionalForm],
  FontSize->18]], "Text",
 CellChangeTimes->{{3.437455479234375*^9, 3.437455485078125*^9}, {
  3.677297282697406*^9, 3.6772972883874135`*^9}},
 FontSize->16],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "D10", ",", "D12", ",", "D13", ",", "D20", ",", "D21", ",", "D22"}], "]"}],
   ";"}]], "Input"],

Cell["\<\
 Starting from these formulae, the following combinations can be analyzed \
\>", "Text",
 CellChangeTimes->{{3.39451426840625*^9, 3.394514268890625*^9}},
 FontSize->18],

Cell[TextData[{
 StyleBox["Dall-Kirkam combination",
  FontWeight->"Bold"],
 ": conic primary mirror and spherical secondary one (K2 = 0)"
}], "Text",
 CellChangeTimes->{3.6772973143074503`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    RowBox[{"D10", "-", " ", "K1"}], "\[Equal]", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"K1", "->", "D10"}], ";"}]}], "Input",
 CellChangeTimes->{{3.412956749234375*^9, 3.41295676196875*^9}, {
  3.677297317237454*^9, 3.6772973174474545`*^9}}],

Cell[TextData[{
 StyleBox["Pressman-Camichel combination",
  FontWeight->"Bold"],
 ": spherical primary (K1 = 0) and conic secondary. "
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{"D10", "+", 
     RowBox[{"D12", " ", "K2"}]}], "\[Equal]", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"K2", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "D10"}], "/", "D12"}]}], ";"}]}], "Input"],

Cell[TextData[{
 StyleBox["Classical Cassegrain",
  FontWeight->"Bold"],
 ": parabolic primary (K1 = -1) and hyperbolic secondary."
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq3", "=", 
   RowBox[{
    RowBox[{"D10", "+", "1", "+", 
     RowBox[{"D12", " ", "K2"}]}], "\[Equal]", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"K2", "->", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"1", "+", "D10"}], "D12"]}]}], ";"}]}], "Input"],

Cell[TextData[{
 StyleBox["Ritchey-Cretien combination",
  FontWeight->"Bold"],
 ": both the mirrors are conic."
}], "Text"],

Cell[BoxData[
 RowBox[{"solrc", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D10", "-", " ", "K1", "+", 
         RowBox[{"D12", " ", "K2"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"D20", "+", 
         RowBox[{"D22", " ", "K2"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"K1", ",", "K2"}], "}"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{
  3.412956803765625*^9, {3.437455505453125*^9, 3.437455506234375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cassegrain combinations examples", "Title",
 CellChangeTimes->{{3.677296496681916*^9, 3.677296503711926*^9}, {
  3.6772965338619685`*^9, 3.67729653518197*^9}}],

Cell["\<\
To use the CassegrainCombination function you can either use directly the \
function CassegrainCombination[ft, f1, em, diam, \[Theta]] or use the \
interactive panel created by calling the function \
CassegrainCombinationInputPanel[].
It let\[CloseCurlyQuote]s you to set input values and then call the \
CassegrainCombination function. Moreover, it helps to load examples from the \
saved archives and set the output style.
Here are some examples\
\>", "Text"],

Cell["Cassegarin 200-4000", "Text",
 CellChangeTimes->{{3.39554372059375*^9, 3.395543728453125*^9}, 
   3.414126847*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ft", "=", "4000."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f1", "=", "1000."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "400."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.2"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "generates", " ", "a", " ", "new", " ", "notebook", " ", 
    "with", " ", "a", " ", "report", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"CassegrainCombination", "[", 
   RowBox[{"ft", ",", "f1", ",", "em", ",", "diam", ",", "\[Theta]"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "the", 
    " ", "summary", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"CassegrainCombination", "[", 
   RowBox[{"ft", ",", "f1", ",", "em", ",", "diam", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "only", 
    " ", "the", " ", "output", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"CassegrainCombination", "[", 
   RowBox[{"ft", ",", "f1", ",", "em", ",", "diam", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "gives", " ", 
     RowBox[{"input", "/", "output"}], " ", "values", " ", "as", " ", "a", 
     " ", "Return", " ", "from", " ", "the", " ", "function"}], ",", " ", 
    RowBox[{
    "with", " ", "labels", " ", "for", " ", "each", " ", "variable"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"CassegrainCombination", "[", 
   RowBox[{"ft", ",", "f1", ",", "em", ",", "diam", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Full\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "gives", " ", "only", " ", "output", " ", "values", " ", 
     "as", " ", "a", " ", "Return", " ", "from", " ", "the", " ", 
     "function"}], ",", " ", 
    RowBox[{"with", " ", "no", " ", "labels", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"useful", " ", "for", " ", "cutting"}], "&"}], "pasting", " ",
        "operations"}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"CassegrainCombination", "[", 
   RowBox[{"ft", ",", "f1", ",", "em", ",", "diam", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Values\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell["Cassegrain 200-2200", "Text",
 CellChangeTimes->{{3.39554372059375*^9, 3.395543728453125*^9}, 
   3.4253552130625*^9, {3.677305633022691*^9, 3.6773056334726915`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ft", "=", "2200."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f1", "=", "600."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "240."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.3"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"CassegrainCombination", "[", 
  RowBox[{"ft", ",", "f1", ",", "em", ",", "diam", ",", "\[Theta]"}], 
  "]"}]], "Input"],

Cell["Cassegrain 200-2000", "Text",
 CellChangeTimes->{{3.39554372059375*^9, 3.395543728453125*^9}, {
  3.6773056364326954`*^9, 3.6773056376826973`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ft", "=", "2000."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f1", "=", "600."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "200."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.5"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"CassegrainCombination", "[", 
  RowBox[{"f1", ",", "ft", ",", "em", ",", "diam", ",", "\[Theta]"}], 
  "]"}]], "Input"],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<CassegrainCombination\>\"", "]"}]], "Input",
 CellChangeTimes->{
  3.677252785520843*^9, {3.6773054912024927`*^9, 3.6773054970725007`*^9}}],

Cell[BoxData[
 RowBox[{"CassegrainCombination", "[", "]"}]], "Input"],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"CassegrainCombinationInputPanel", "[", "]"}]], "Input",
 CellChangeTimes->{3.6772527986159506`*^9, 3.677305438882419*^9}]
}, Open  ]]
},
WindowSize->{1904, 992},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
WindowFrame->"Normal",
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "GeometricOptics.nb"]]}, Visible -> False, 
  FrontEndVersion -> "11.0 for Microsoft Windows (64-bit) (July 28, 2016)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 105, 1, 71, "Title"],
Cell[CellGroupData[{
Cell[709, 27, 35, 0, 43, "Subsection"],
Cell[747, 29, 116, 2, 46, "Text"],
Cell[866, 33, 1495, 40, 261, "Text"],
Cell[2364, 75, 2110, 53, 389, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4511, 133, 40, 0, 43, "Subsection"],
Cell[4554, 135, 257, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4848, 146, 40, 0, 43, "Subsection"],
Cell[4891, 148, 111, 2, 46, "Text"],
Cell[5005, 152, 3193, 83, 551, "Text"],
Cell[8201, 237, 2296, 56, 473, "Text"],
Cell[10500, 295, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14014, 390, 106, 1, 71, "Title"],
Cell[14123, 393, 1312, 21, 94, "Text"],
Cell[15438, 416, 123, 3, 46, "Text"],
Cell[15564, 421, 318, 6, 52, "Text"],
Cell[15885, 429, 270, 6, 58, "Text"],
Cell[16158, 437, 327, 8, 56, "Text"],
Cell[16488, 447, 357, 10, 57, "Text"],
Cell[16848, 459, 1076, 18, 46, "Text"],
Cell[17927, 479, 1210, 22, 142, "Text"],
Cell[19140, 503, 300, 6, 46, "Text"],
Cell[19443, 511, 1952, 60, 333, "Input"],
Cell[21398, 573, 148, 2, 46, "Text"],
Cell[21549, 577, 2163, 68, 104, "Input"],
Cell[23715, 647, 219, 6, 46, "Text"],
Cell[23937, 655, 303, 9, 35, "Input"],
Cell[24243, 666, 208, 7, 35, "Input"],
Cell[24454, 675, 208, 7, 35, "Input"],
Cell[24665, 684, 291, 5, 45, "Text"],
Cell[24959, 691, 613, 21, 46, "Text"],
Cell[25575, 714, 275, 4, 45, "Text"],
Cell[25853, 720, 302, 9, 35, "Input"],
Cell[26158, 731, 207, 7, 35, "Input"],
Cell[26368, 740, 207, 7, 35, "Input"],
Cell[26578, 749, 352, 10, 45, "Text"],
Cell[26933, 761, 512, 19, 47, "Text"],
Cell[27448, 782, 159, 5, 32, "Input"],
Cell[27610, 789, 178, 4, 46, "Text"],
Cell[27791, 795, 194, 5, 46, "Text"],
Cell[27988, 802, 306, 8, 55, "Input"],
Cell[28297, 812, 147, 4, 46, "Text"],
Cell[28447, 818, 264, 9, 55, "Input"],
Cell[28714, 829, 143, 4, 46, "Text"],
Cell[28860, 835, 293, 10, 70, "Input"],
Cell[29156, 847, 124, 4, 46, "Text"],
Cell[29283, 853, 559, 17, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29879, 875, 165, 2, 71, "Title"],
Cell[30047, 879, 471, 9, 94, "Text"],
Cell[30521, 890, 120, 2, 46, "Text"],
Cell[30644, 894, 301, 10, 121, "Input"],
Cell[30948, 906, 415, 10, 55, "Input"],
Cell[31366, 918, 463, 10, 55, "Input"],
Cell[31832, 930, 490, 10, 55, "Input"],
Cell[32325, 942, 640, 13, 55, "Input"],
Cell[32968, 957, 759, 17, 55, "Input"],
Cell[33730, 976, 172, 2, 46, "Text"],
Cell[33905, 980, 300, 10, 121, "Input"],
Cell[34208, 992, 143, 3, 32, "Input"],
Cell[34354, 997, 153, 2, 46, "Text"],
Cell[34510, 1001, 300, 10, 121, "Input"],
Cell[34813, 1013, 143, 3, 32, "Input"],
Cell[34959, 1018, 65, 0, 46, "Text"],
Cell[35027, 1020, 187, 3, 32, "Input"],
Cell[35217, 1025, 69, 1, 32, "Input"],
Cell[35289, 1028, 70, 0, 46, "Text"],
Cell[35362, 1030, 145, 2, 32, "Input"]
}, Open  ]]
}
]
*)

